#include <stdio.h>
#include <math.h>

int main(int argc, char *argv[]) {
  double k=0.05;
  double B=7.5; 
  double x0;
  double x1=3.0;
  double x2;
  double dx=4.0;
  double dt=M_PI/100.0; 
  double ddt; 
  int  i,j=0;

  ddt    = dt*dt; 
  x0     =x1-dx*dt;

  for (i=0; i<10000000; i++, j++) {
    x2 = (ddt*B * cos(j*dt) + (2+dt*k)*x1 -x0 - 
          ddt*x1*x1*x1)/(1+dt*k);
    if ((j%1000) == 0) printf("%f %f\n",x2,(x2-x1)/dt);
    x0=x1; x1=x2;
  }
  return 0;
}
