#!/usr/bin/wish -f

global countries is1 sc
wm title . "Europa"
wm minsize . 50 50
frame .f -bg grey -bd 2;# to hold canvas and scrollbars
pack .f
frame .f.sub  -bg red -bd 2 ;# to hold canvas
pack .f.sub -in .f 
canvas .f.sub.c -relief sunken -width 15c -height 15c 
        

pack .f.sub.c -in .f.sub -side left -fill y -padx 2
set w .f.sub.c


frame .info
pack .info
frame .info.sub1
pack .info.sub1 -padx 4 -pady 4 -ipadx 4 -ipady 4
set is1 .info.sub1
label $is1.labcountry -text "Country" -justify right
entry $is1.country   -relief sunken -textvariable sc 

pack $is1.labcountry $is1.country -side left -padx 4 -pady 3 -ipadx 2 -ipady 2
bind $is1.country <Return> {highLightCountry $w $sc}
#
# buttons
#
frame .b -bg grey 
pack .b -fill x

button .b.quit -text Quit -command {exit 0}
button .b.clear -text Clear -command {clearCanvas .f.sub.c}

pack .b.quit .b.clear -side right -padx 4 -pady 4


proc clearCanvas { w } {
	 foreach id [$w  find all] { $w delete $id }
}

#
# coordinates from PHIGS Programming Manual, by Tom Gaskins, Appendix D
# adopted for the Tk canvas widget coordinate system  for the
# AGOCG Tcl/Tk cookbook
#

$w create polygon  \
1.33039 0.57027 1.36029 0.59123 1.34591 0.50223 1.34591 0.44262 \
1.33314 0.41707 1.32797 0.37687 1.30972 0.35746 1.27992 0.3532 \
1.2565 0.33617 1.24296 0.32417 1.21179 0.32979 1.19902 0.34469 \
1.17347 0.34469 1.14416 0.36309 1.12876 0.34895 1.14792 0.34043 \
1.14154 0.31488 1.11386 0.31488 1.10109 0.29998 1.07054 0.29423 \
1.03341 0.29185 1.02019 0.32766 1.02019 0.34895 1.02861 0.38514 \
1.02861 0.41158 1.00742 0.39152 0.98251 0.38164 0.98251 0.4043 \
0.96484 0.39152 0.94359 0.41876 0.93879 0.48524 0.88614 0.51518 \
0.88614 0.60021 0.88852 0.64209 0.91374 0.65977 0.89988 0.68344 \
0.99688 0.72716 0.96694 0.81694 1.07471 0.82592 1.25673 0.82354 \
1.30943 0.73852 1.21301 0.62593 1.33039 0.57027 \
-fill green   -tag germany
$w bind germany <Button-1> {showName Germany}
 
$w create polygon \
0.88852 0.64209 0.91374 0.65977 \
0.89988 0.68344 0.86993 0.67863 0.88852 0.64209\
  -fill bisque4 -tag luxemburg
$w bind luxemburg <Button-1> {showName Luxemburg}
$w create polygon \
1.07471 0.82592 1.25673 0.82354 1.30943 0.73852 1.34288 0.75019 \
1.37815 0.7365 1.407 0.71653 1.47287 0.73372 1.49383 0.78462 \
1.47272 0.80309 1.44708 0.80309 1.45028 0.83194 1.43395 0.86727 \
1.4038 0.88484 1.36853 0.87852 1.34449 0.90247 1.30046 0.89721 \
1.24831 0.88074 1.21782 0.85586 1.16335 0.85278 1.128 0.86965 \
1.0867 0.86067 1.07471 0.82592\
  -fill PeachPuff2 -tag austria
$w bind austria <Button-1> {showName Austria}
$w create polygon  \
0.94359 0.41876 0.93879 0.48524 0.88614 0.51518 0.88614 0.60021 \
0.83344 0.54989 0.7526 0.55649 0.78826 0.53219 0.81711 0.51936 \
0.8091 0.50333 0.81711 0.48249 0.83314 0.4841 0.85719 0.48249 \
0.81391 0.46486 0.8123 0.44402 0.82513 0.41998 0.85858 0.41876 \
0.94359 0.41876\
  -fill LemonChiffon1 -tag netherlands
$w bind netherlands <Button-1> {showName Netherlands}
$w create polygon \
0.7526 0.55649 0.83344 0.54989 0.88614 0.60021 0.88852 0.64209 \
0.86993 0.67863 0.82833 0.65084 0.82994 0.61554 0.8091 0.62035 \
0.79948 0.64439 0.77864 0.64119 0.76843 0.608 0.7113 0.57265 \
0.72895 0.55783 0.7526 0.55649\
  -fill honeydew1 -tag belgium
$w bind belgium <Button-1> {showName Belgium}

$w create polygon \
1.03341 0.29185 1.02069 0.26129 1.0011 0.24153 0.99344 0.20518 \
1.00786 0.17953 1.01245 0.13976 1.03672 0.11381 1.08481 0.10259 \
1.10084 0.08175 1.128 0.07808 1.1345 0.11221 1.10565 0.13305 \
1.10227 0.16311 1.11847 0.17793 1.14251 0.16992 1.14837 0.18824 \
1.12328 0.22121 1.07951 0.22954 1.0816 0.28052 1.07054 0.29423 \
1.03341 0.29185\
   -fill LavenderBlush1 -tag denmark 
$w bind denmark <Button-1> {showName Denmark}
$w create polygon \
1.1345 0.23724 1.11366 0.24045 1.11045 0.25648 1.12488 0.2709 \
1.13129 0.28533 1.14412 0.27571 1.14893 0.25327 1.1345 0.23724\
   -fill LavenderBlush1 -tag fyn
$w bind fyn <Button-1> {showName Fyn}
$w create polygon \
1.22587 0.20198 1.20182 0.21159 1.20022 0.22602 1.21465 0.23884 \
1.19862 0.24846 1.18259 0.23724 1.1874 0.22281 1.16976 0.20999 \
1.15854 0.23243 1.16335 0.26129 1.18099 0.27892 1.20022 0.27251 \
1.16656 0.30296 1.21304 0.28373 1.20984 0.2677 1.22747 0.26129 \
1.23388 0.23564 1.21946 0.2164 1.23709 0.20999 1.22587 0.20198\
   -fill LavenderBlush1 -tag  sjaelland
$w bind sjaelland <Button-1> {showName Sjaelland}
$w create polygon \
0.7113 0.57265 0.76843 0.608 0.77864 0.64119 0.79948 0.64439 \
0.8091 0.62035 0.82994 0.61554 0.82833 0.65084 0.86993 0.67863 \
0.89988 0.68344 0.99688 0.72716 0.96694 0.81694 0.93413 0.82874 \
0.91169 0.87183 0.88614 0.89721 0.88764 0.9153 0.90688 0.91183 \
0.9181 0.92972 0.93879 0.93433 0.94535 0.98102 0.92743 1.00315 \
0.94695 1.03552 0.97115 1.04193 0.97115 1.07444 0.89749 1.1253 \
0.78253 1.09298 0.73405 1.11632 0.73405 1.16902 0.65142 1.16664 \
0.62636 1.13811 0.58628 1.12689 0.55583 1.13212 0.51255 1.1186 \
0.51255 1.09002 0.4869 1.11059 0.46701 1.10438 0.47889 1.08842 \
0.49011 1.04834 0.51255 1.00346 0.51095 0.9698 0.49812 0.90408 \
0.49331 0.88965 0.47728 0.88804 0.45965 0.87682 0.45645 0.85759 \
0.47272 0.84689 0.45484 0.83515 0.43721 0.83996 0.41156 0.83675 \
0.41797 0.82553 0.40515 0.83194 0.36988 0.81751 0.34584 0.81591 \
0.33109 0.80558 0.32981 0.78866 0.31699 0.77584 0.31076 0.75468 \
0.3234 0.73897 0.34744 0.73737 0.36508 0.72614 0.38752 0.73416 \
0.41156 0.76141 0.4324 0.74378 0.46767 0.74378 0.48317 0.7523 \
0.48209 0.71492 0.46767 0.69248 0.4628 0.67625 0.49331 0.67004 \
0.51736 0.68287 0.57026 0.68126 0.59396 0.69003 0.60552 0.68126 \
0.5943 0.67325 0.60552 0.65401 0.64239 0.62195 0.66039 0.58881 \
0.7113 0.57265 -fill  SlateBlue1 -tag  france
$w bind france <Button-1> {showName France}
$w create polygon \
0.96694 0.81694 0.93413 0.82874 0.91169 0.87183 0.88614 0.89721 \
0.88764 0.9153 0.90688 0.91183 0.9181 0.92972 0.93879 0.93433 \
0.98863 0.91156 0.99825 0.89125 1.03191 0.89927 1.0472 0.93433 \
1.08 0.89285 1.128 0.86965 1.0867 0.86067 1.07471 0.82592 0.96694 0.81694\
    -fill RoyalBlue1  -tag switzerland

$w bind switzerland <Button-1> {showName Switzerland}

$w create polygon \
1.30046 0.96185 1.30046 0.89721 1.24831 0.88074 1.21782 0.85586 \
1.16335 0.85278 1.128 0.86965 1.08 0.89285 1.0472 0.93433 1.03191 \
0.89927 0.99825 0.89125 0.98863 0.91156 0.93879 0.93433 0.94535 \
0.98102 0.92743 1.00315 0.94695 1.03552 0.97115 1.04193 0.97115 \
1.07444 0.99504 1.07239 1.02229 1.05475 1.0406 1.0379 1.07038 \
1.04193 1.11526 1.05636 1.13771 1.08361 1.13931 1.11246 1.15534 \
1.1333 1.16934 1.16664 1.20182 1.1894 1.22907 1.21184 1.26915 \
1.22467 1.3509 1.27596 1.35891 1.28879 1.37174 1.28879 1.38616 \
1.2952 1.39097 1.30482 1.40861 1.30642 1.41662 1.33046 1.41983 \
1.36413 1.42944 1.38817 1.41983 1.40901 1.42624 1.42664 1.41181 \
1.44107 1.39739 1.42824 1.38136 1.43145 1.3525 1.44588 1.29319 \
1.44748 1.27556 1.45229 1.25793 1.45069 1.24991 1.46832 1.27075 \
1.47313 1.28037 1.46832 1.30762 1.49076 1.3493 1.5132 1.37975 \
1.53244 1.39739 1.52923 1.4054 1.5132 1.39739 1.49236 1.39578 \
1.4603 1.42784 1.43786 1.44387 1.44267 1.46311 1.42344 1.47433 \
1.39618 1.49383 1.3876 1.49677 1.37695 1.49517 1.3513 1.48395 \
1.33688 1.47112 1.32886 1.47112 1.31123 1.48395 1.2984 1.50478 \
1.30161 1.51921 1.31443 1.53364 1.31283 1.54806 1.32726 1.56987 \
1.33367 1.56987 1.31631 1.56089 1.2968 1.53524 1.28237 1.50959 \
1.27596 1.48074 1.25032 1.44067 1.23108 1.43105 1.21665 1.44067 \
1.20223 1.43105 1.19261 1.37013 1.18139 1.33006 1.14933 1.31243 \
1.12048 1.29319 1.0804 1.28037 1.06758 1.25953 1.06918 1.2451 \
1.05475 1.24831 1.03231 1.2451 1.01147 1.23228 0.98903 1.23869 \
0.96819 1.27235 0.9698 1.30046 0.96185\
   -fill  SteelBlue1 -tag italy  
$w bind italy <Button-1> {showName Italy}

$w create polygon \
1.06557 1.12849 1.04794 1.1365 1.05275 1.15253 1.03672 1.16376 \
1.0271 1.18139 1.03031 1.20223 1.05275 1.22627 1.07038 1.23429 \
1.08481 1.21665 1.07359 1.20543 1.08641 1.17978 1.0832 1.13811 \
1.07198 1.10284 1.06557 1.12849 \
  -fill SteelBlue1 -tag sardinia
$w bind sardinia <Button-1> {showName Sardinia}

$w create polygon  \
1.06076 1.24551 1.02389 1.26154 1.00786 1.25512 1.01588 1.2407 \
0.99985 1.25673 1.00786 1.26955 1.01909 1.28077 1.0271 1.31123 \
1.01588 1.33046 1.00786 1.31924 1.01428 1.34008 1.00786 1.36573 \
1.02389 1.38496 1.04794 1.38657 1.04794 1.37214 1.05916 1.37214 \
1.06878 1.37855 1.07679 1.36733 1.07519 1.34329 1.0832 1.31924 \
1.07679 1.2984 1.09282 1.2952 1.09282 1.27276 1.07359 1.2439 \
1.06076 1.24551\
   -fill SteelBlue1 -tag corsica
$w bind corsica <Button-1> {showName Corsica}

$w create polygon  \
0.73405 1.16902 0.65142 1.16664 0.62636 1.13811 0.58628 1.12689 \
0.55583 1.13212 0.51255 1.1186 0.51255 1.09002 0.4869 1.11059 \
0.46701 1.10438 0.44042 1.10765 0.41316 1.09803 0.33302 1.09002 \
0.26409 1.09322 0.21921 1.082 0.17913 1.07559 0.15509 1.08681 \
0.13585 1.09803 0.11341 1.09322 0.08776 1.10765 0.05988 1.13252 \
0.05731 1.15253 0.06532 1.17337 0.0783 1.18494 0.0783 1.19581 \
0.08502 1.20701 0.11982 1.19742 0.13265 1.21195 0.12143 1.22948 \
0.15348 1.2137 0.18875 1.21098 0.22753 1.21993 0.21528 1.24551 \
0.19196 1.26314 0.19148 1.2952 0.16586 1.34868 0.14066 1.3513 \
0.17432 1.39618 0.16474 1.41863 0.17753 1.45389 0.15348 1.47313 \
0.16344 1.50077 0.19837 1.5132 0.23203 1.53404 0.23684 1.55808 \
0.26942 1.57201 0.29615 1.56581 0.31218 1.54847 0.33943 1.54366 \
0.35866 1.54686 0.37149 1.53885 0.40355 1.53083 0.434 1.53244 \
0.45805 1.52603 0.49011 1.48916 0.50774 1.4587 0.543 1.43786 \
0.57667 1.40741 0.58468 1.38336 0.56545 1.38336 0.55423 1.36573 \
0.55904 1.34008 0.57506 1.31123 0.60552 1.27596 0.67765 1.2439 \
0.7017 1.23108 0.72735 1.19742 0.73405 1.16902 \
    -fill  LightSkyBlue1  -tag spain
$w bind spain <Button-1> {showName Spain}

$w create polygon \
0.08502 1.20701 0.11982 1.19742 0.13265 1.21195 0.12143 1.22948 \
0.15348 1.2137 0.18875 1.21098 0.22753 1.21993 0.21528 1.24551 \
0.19196 1.26314 0.19148 1.2952 0.16586 1.34868 0.14066 1.3513 \
0.17432 1.39618 0.16474 1.41863 0.17753 1.45389 0.15348 1.47313 \
0.16344 1.50077 0.12784 1.5148 0.107 1.50704 0.08264 1.50975 \
0.06692 1.5132 0.06692 1.49717 0.08662 1.46992 0.0851 1.41992 \
0.05269 1.40376 0.04609 1.36573 0.05731 1.34649 0.05089 1.34329 \
0.0722 1.28558 0.08502 1.2070\
    -fill SlateGray2  -tag portugal
$w bind portugal <Button-1> {showName Portugal}

$w create polygon \
0.29218 0.00863 0.32019 0.0 0.35225 0.00481 0.38271 0.0 0.39335 \
0.00621 0.38591 0.03847 0.36508 0.06893 0.34744 0.07214 0.35225 \
0.07855 0.33589 0.08944 0.35706 0.09618 0.43721 0.10259 0.434 \
0.12183 0.42439 0.15549 0.40355 0.18755 0.38676 0.20037 0.38676 \
0.21159 0.42118 0.21961 0.4742 0.24333 0.4869 0.2677 0.52698 \
0.30777 0.56224 0.34784 0.573 0.37687 0.55743 0.38151 0.5382 \
0.3783 0.51896 0.3783 0.54544 0.38644 0.57186 0.39593 0.58435 \
0.41876 0.56402 0.44632 0.57506 0.45204 0.61834 0.44402 0.65142 \
0.4601 0.63117 0.51936 0.59813 0.54513 0.60232 0.55463 0.62796 \
0.55302 0.63764 0.57027 0.56705 0.60913 0.49171 0.61073 0.42599 \
0.62035 0.38591 0.61233 0.36027 0.63317 0.33462 0.6492 0.30577 \
0.65081 0.28012 0.65561 0.25743 0.65349 0.26249 0.64439 0.28813 \
0.62997 0.30897 0.60111 0.33783 0.58028 0.37149 0.57867 0.38591 \
0.56104 0.40515 0.55302 0.42091 0.53135 0.37719 0.55231 0.33302 \
0.54501 0.29935 0.52257 0.28974 0.50494 0.34725 0.47146 0.3218 \
0.45204 0.33141 0.43441 0.31218 0.42158 0.32821 0.41196 0.33622 \
0.4296 0.36668 0.41677 0.40475 0.40682 0.40194 0.38311 0.4167 \
0.34693 0.39874 0.34784 0.38431 0.34784 0.36828 0.33182 0.37469 \
0.30617 0.39578 0.29185 0.3795 0.29014 0.36027 0.30617 0.33783 \
0.31098 0.29455 0.30617 0.28333 0.26609 0.29218 0.2158 0.24846 \
0.26191 0.24165 0.24045 0.26569 0.20037 0.27363 0.16548 0.24966 \
0.16831 0.2323 0.16072 0.24004 0.11381 0.20157 0.10419 0.20638 \
0.08817 0.22081 0.09458 0.21279 0.08175 0.22722 0.07694 0.24325 \
0.1074 0.24646 0.06733 0.29218 0.00863\
   -fill  LightSteelBlue1 -tag gb

$w bind gb <Button-1> {showName "Great Britain"}


$w create polygon \
0.216 0.02244 0.18875 0.03847 0.18394 0.07374 0.17432 0.10099 \
0.14707 0.13144 0.18394 0.109 0.19676 0.07053 0.22241 0.04008 0.216 0.02244\
    -fill LightSteelBlue1 -tag hebrides
$w bind  hebrides <Button-1> {showName Hebrides}

$w create polygon  \
0.17432 0.27327 0.22081 0.27571 0.23363 0.29655 0.25287 0.30937 \
0.25768 0.33502 0.22753 0.36309 0.20592 0.32898 0.1449 0.34693 \
0.12155 0.32417 0.1497 0.29185 0.17432 0.27327\
    -fill LightCyan1 -tag  nireland
$w bind nireland <Button-1> {showName "Northern Ireland"}

$w create polygon  \
0.22753 0.36309 0.20592 0.32898 0.1449 0.34693 0.12155 0.32417 \
0.1497 0.29185 0.12155 0.27807 0.10539 0.29495 0.10219 0.31098 \
0.08295 0.32701 0.09637 0.34272 0.07654 0.34624 0.06372 0.35586 \
0.04609 0.35265 0.02525 0.35105 0.01135 0.36547 0.02756 0.3783 \
0.02756 0.41158 0.0525 0.41677 0.07604 0.42056 0.03486 0.45524 \
0.03232 0.47146 0.04769 0.47146 0.08502 0.46248 0.04929 0.47769 \
0.02044 0.47929 0.0 0.4966 0.0 0.51135 0.03166 0.50814 0.03654 \
0.51995 0.01616 0.52417 0.01616 0.53853 0.04609 0.53219 0.07013 \
0.53379 0.15669 0.51295 0.19676 0.50974 0.21133 0.4966 0.22562 \
0.42799 0.21921 0.39914 0.22753 0.36309\
   -fill SpringGreen1 -tag eire

$w bind eire <Button-1> {showName Eire}

set countries {germany luxemburg austria netherlands belgium \
denmark fyn sjaelland france switzerland italy sardinia \
corsica spain portugal gb hebrides nireland eire}

foreach c $countries {
	 $w scale $c 0 0 300 300
}


proc showName {c} {
global is1
$is1.country delete 0 end
$is1.country insert end $c

}


# given a country flash that in canvas

proc highLightCountry { w tn } {
 set old_colour [lindex [$w itemconfig $tn -fill] 4]
 
 $w itemconfigure $tn -fill yellow
 after 50 "$w itemconfigure $tn -fill $old_colour; bell"

}



